#ifndef usb_R8_2H
#define usb_R8_2H
#include <assert>
#include <classes.hpp>

#define searchMaxDevices 10 //maksymalna liczba interfejsw urzdzen

using namespace std;
//---------------------------------------------------------
template <class T>
inline void releaseMemory(T &x)
{
  assert(x != NULL);
  delete x;
  x = NULL;
}
//---------------------------------------------------------
template <class T>
inline void releaseThread(T &x)
{
  assert(x != NULL);
  x->Terminate();
  delete x;
  x = NULL;
}
//---------------------------------------------------------
typedef USHORT USAGE, *PUSAGE;
typedef struct _HIDP_PREPARSED_DATA *PHIDP_PREPARSED_DATA;
//--------------------------------------------------------
typedef struct _HIDP_CAPS {
   USAGE Usage;
   USAGE UsagePage;
   USHORT InputReportByteLength;
   USHORT OutputReportByteLength;
   USHORT FeatureReportByteLength;
   USHORT Reserved[17];
   USHORT NumberLinkCollectionNodes;
   USHORT NumberInputButtonCaps;
   USHORT NumberInputValueCaps;
   USHORT NumberInputDataIndices;
   USHORT NumberOutputButtonCaps;
   USHORT NumberOutputValueCaps;
   USHORT NumberOutputDataIndices;
   USHORT NumberFeatureButtonCaps;
   USHORT NumberFeatureValueCaps;
   USHORT NumberFeatureDataIndices;
} HIDP_CAPS, *PHIDP_CAPS;
//---------------------------------------------------------
typedef struct _DEVICE_DATA {
  TCHAR   *HardwareId;
  TCHAR   *Path;
  DWORD   DeviceInstance;
  HANDLE  hidDeviceObject;
  BYTE    *inputReportBuffer;
  USHORT  inputReportByteLength;
  PHIDP_PREPARSED_DATA preparsedData;
  HIDP_CAPS capabilities;
} DEVICE_DATA, *PDEVICE_DATA;
//---------------------------------------------------------
class TUSBDevice {
   private:
      UINT fMemberIndex;
      void displayError(const char* msg);
   public:
      PDEVICE_DATA deviceList;
      BOOL getHidDeviceCapabilities(UINT memberIndex);
      UINT setGetHidDeviceData();
      HANDLE openHidUSBDevice(UINT memberIndex);
      BOOL readUSBReport(UINT memberIndex);
      BOOL closeHidUSBDevice(HANDLE devHandle);
      TUSBDevice(UINT memberIndes);
      ~TUSBDevice();
};
//---------------------------------------------------------
class TThreadUSBPort: public TThread
{
  private:
    TUSBDevice *usbDevice;
    UINT *fRunThread;
    UINT fMemberIndex;
  protected:
    void __fastcall Execute();
  public:
    TThreadUSBPort(BOOL CreateSuspended, UINT *runThread,
                   UINT memberIndex);
};
//---------------------------------------------------------
#endif
 